/*  Using_the_R4_DAC_to_gen_a_sawtooth.ino
 *  A sketch for using the DAC in the Arduino R4 Minima
 *  to generate a sawtooth waveform.
 *  Written by Jim Rowe for Silicon Chip, on the 29th September 2023.
 *  Last revised at 2:20 pm
 *  Note that the DAC's output appears at the A0 pin.
 *  Also although the DAC is described as having a resolution of 12 bits,
 *  it has a default resolution of 8 bits. This can only be changed by using
 *  the instruction analogWriteResolution(12). We use the default resolution here.
 */

 int x = 4;  // the increment quantity
  
void setup()
{
  Serial.begin(9600);   // then start up serial comms to PC at 9600 baud
  while(!Serial){}  // then wait until R4 serial port is awake
  Serial.println("This sketch is for using the Arduino R4 Minima's DAC to generate");
  Serial.println("a linear sawtooth waveform");
}

void loop()
{
  for (x=0; x<255; x+=4)
  {
    analogWrite(A0, x);  // then send it to the DAC
    delayMicroseconds(2000);
  }
}
